/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef SPICE3_SCANNERCOMMUNICATION_API_
#define SPICE3_SCANNERCOMMUNICATION_API_

#include "rlTypes.h"

RL_C_API rlResult rlScannerCommunicationTransceiveEnhanced(rlHandle handle, int32_t head, rlAxes axes, const uint32_t* commands, uint32_t commandsLength,
    int32_t timeoutMilliseconds, uint32_t* buffer, uint32_t bufferSize, uint32_t* receiveCount);
RL_C_API rlResult rlScannerCommunicationTransmitEnhanced(
    rlHandle handle, int32_t head, rlAxes axes, const uint32_t* commands, uint32_t commandsLength, int32_t timeoutMilliseconds);
RL_C_API rlResult rlScannerCommunicationReceiveEnhanced(
    rlHandle handle, int32_t head, rlAxes axes, int32_t timeoutMilliseconds, uint32_t* buffer, uint32_t bufferSize, uint32_t* receiveCount);
RL_C_API rlResult rlScannerCommunicationTransceiveRaylase(rlHandle handle, int32_t head, rlAxis axis, const unsigned char* transmitMessage,
    uint32_t transmitMessageLength, int32_t timeoutMilliseconds, unsigned char* buffer, uint32_t bufferSize, uint32_t* receiveCount);
RL_C_API rlResult rlScannerCommunicationTransmitRaylase(
    rlHandle handle, int32_t head, rlAxis axis, const unsigned char* transmitMessage, uint32_t transmitMessageLength, int32_t timeoutMilliseconds);

#endif // _SPICE3_SCANNERCOMMUNICATION_API_